<?php
/*
Plugin Name: Sleek Cats
Plugin URI: http://www.alltrees.org/Wordpress/
Description: Replaces post categories with a breadcrumb-style hierarchical list that contains no repeats of parent categories.
Author: Emily Ravenwood and Ken Irwin
Version: 2.0
Author URI: http://www.alltrees.org/
License: GPL v3 (http://www.gnu.org/copyleft/gpl.html) 2007
*/

function sleek_cats() {

	// define the separator
	$sep = "<br/>";
	
	//buffer a list of all a posts categories in hierarchical form, using the designated separator; should be the same output as the_category set to multiple
	ob_start();
	foreach((get_the_category()) as $category) {
		$contents = (get_category_parents($category->cat_ID, TRUE, '/')) . $sep;
		$contents = str_replace("/$sep", "$sep", $contents); //get rid of the extra / on the end	
		echo $contents;
	}	
	$cats = ob_get_contents();
	ob_end_clean();

	// split each category into an array, breaking at the separator
	$cat_a = split($sep, $cats);
	foreach($cat_a as $key => $cat) {
		$plain = strip_tags($cat); //take out the a tags because the /a screws up the next part
		$plain_cats[$plain] = $key; //map the result
		$cat_a[$key] = str_replace ('</a>/<a', '</a><span style="color: #666666; padding: 0 2px;"> &raquo; </span><a', $cat); //replace default relation character with something more meaningful for when it's put back together
	} // end foreach cat_a
	
	// take anything in the stripped array that comes in front of a / and delete it when it stands alone
	foreach($plain_cats as $cat => $key) {
		if (preg_match('/(.+)\/.+/', $cat, $m)) {
			if(in_array($m[1], $plain_cats)) {			
				$delete_title = $m[1];
				$delete_key = $plain_cats["$delete_title"];
				if ($delete_key == '') { $delete_key = "0"; }
				unset ($cat_a[$delete_key]);
			} //end if in_array
		} // end if preg_match
	} // end foreach plain_cats
	
	
	// put the split array back together
	$output = (join($sep, $cat_a));
	
	//escape slashes in the separator
	$temp_sep = addcslashes($sep, "/");
	//print the output, first replacing the trailing seperator with a space
	echo preg_replace("/$temp_sep$/", " ", $output);
	
}// end function

if (!is_admin()) { //keep from screwing with the admin page uses
add_filter('the_category', 'sleek_cats');
}
?>